#ifndef __REPERTOIRE_H__
#define __REPERTOIRE_H__

#define TYPE_REPERTOIRE 100

#include "global.h"

#define SET_MASK ((((u64)1)<<56)-1)


#define ACTIVATED(a)	(((a)>>56) & 0xFF)
#define R_SET(a)	((a) & SET_MASK)
#define REPERTOIRE(a,b) ((((u64)(a))<<56) | (R_SET(b)))

typedef struct {
	int size;
	int bias_max;
	int bias_min;
	int bias_vol;  /* in % */
	int *bias_values;
	int *data1;
	int walk_bias; /* whether the bias should jump (0) */
	} REPERTOIRE_VALUES;

typedef struct {
	int size;       /* less or equal to size in R_V above */
	u64 mask_in;     /* which should be included */
	u64 mask_random; /* which can be chosen randomly */
	int size_strict; /* should it be always full */
	int activated;  /* -1 if random */
	} REPERTOIRE_PARAMS;

u64 make_repertoire(REPERTOIRE_VALUES *r_v,REPERTOIRE_PARAMS *r_p);
void init_bias_values(REPERTOIRE_VALUES *r_v);
void dump_attr_rp(FILE *fout,REPERTOIRE_VALUES *r_v);
int get_repertoire_size(long index);
void evolve_repertoire(REPERTOIRE_VALUES *r_v);

#endif
